#include <iostream>
#include <cstdio>
#include <vector>
#include <set>
#include <algorithm>

using namespace std;
typedef long long ll;
const int MAXN = 200010;
const ll INF = 100000000000000LL;

template <typename T>
struct chtholly_tree {
	int n;
	struct node {
		int l; mutable int r; mutable T val;
		bool operator <(node b) const {
			return l<b.l;
		}
	};
	typedef typename set<node>::iterator ctl;
	set<node> odt;
	chtholly_tree() {
		n=0; odt.clear();
	}
	chtholly_tree(vector<T> a) {
		odt.clear(); n=a.size();
		T lval=T(); int lpos=-1;
		for (int i=0; i<n; ++i) {
			if ((a[i]!=lval)||(!i)) {
				if (lpos!=-1) odt.insert((node){lpos,i-1,lval});
				lpos=i; lval=a[i];
			}
		}
		odt.insert((node){lpos,n-1,lval});
	}
	chtholly_tree operator==(vector<T> a) const {
		chtholly_tree<T> res(a); n=res.n;
		for (ctl it=a.odt.begin(); it!=a.odt.end(); ++it) odt.insert(*it);
		return res;
	}
	~chtholly_tree() {
		odt.clear();
	}
	ctl find(int pos) {
		pos=min(n-1,pos); pos=max(0,pos);
		ctl it = odt.lower_bound((node){pos,0,T()});
		if (it==odt.end()) --it;
		if (pos<it->l) --it;
		return it;
	}
	void push_back(T x, int cnt=1) {
		n += cnt;
		if (n==cnt) odt.insert((node){0,cnt-1,x});
		else {
			ctl it=odt.end(); --it;
			if (x==it->val) (it->r)+=cnt;
			else odt.insert((node){n-cnt,n-1,x});
		}
	}
	pair<ctl,ctl> split(int l, int r) {
		if (l>r) swap(l,r);
		l=max(0,l); r=min(n-1,r);
		ctl il=find(l), ir=find(r);
		if (il==ir) {
			if ((l==il->l)&&(r==il->r)) return make_pair(il,il);
			node o = *il;
			if (l==o.l) {
				il->r=r; odt.insert((node){r+1,o.r,o.val});
			}
			else if (r==o.r) {
				il->r=l-1; il=odt.insert((node){l,o.r,o.val}).first;
			}
			else {
				il->r=l-1; odt.insert((node){r+1,o.r,o.val});
				il = odt.insert((node){l,r,o.val}).first;
			}
			return make_pair(il,il);
		}
		if (l>il->l) {
			node o=*il; il->r=l-1;
			il = odt.insert((node){l,o.r,o.val}).first;
		}
		if (r<ir->r) {
			node o=*ir; ir->r=r;
			odt.insert((node){r+1,o.r,o.val});
		}
		return make_pair(il,ir);
	}
	vector<node> split_value(int l, int r) {
		vector<node> res; if (n<1) return res;
		if (l>r) swap(l,r);
		ctl s=find(l), t=find(r);
		for (ctl it=s; ; ++it) {
			res.push_back((node){max(l,it->l),min(r,it->r),it->val});
			if (it==t) break;
		}
		return res;
	}
	void assign(int l, int r, T k) {
		pair<ctl,ctl> p=split(l,r); ctl s=p.first, t=p.second;
		odt.erase(s,++t); odt.insert((node){l,r,k});
	}
};
chtholly_tree<ll> tr;
vector<pair<ll,int> > vec, qry;
vector<chtholly_tree<ll>::node> tmp;
ll res[MAXN];

char buf[131072], *cs, *ct, *os, *ot, ss[20];
inline char gc() {
	if (cs==ct) {
		ct = (cs=buf)+fread(buf,1,131072,stdin);
		if (cs==ct) return 0;
	}
	return *cs++;
}
inline int read() {
	int r=0; char ch=gc();
	while ((ch<'0')||(ch>'9')) ch=gc();
	while ((ch>='0')&&(ch<='9')) {
		r=r*10+(ch^'0'); ch=gc();
	}
	return r;
}
inline ll lread() {
	ll r=0LL; char ch=gc();
	while ((ch<'0')||(ch>'9')) ch=gc();
	while ((ch>='0')&&(ch<='9')) {
		r=r*10LL+ll(ch^'0'); ch=gc();
	}
	return r;
}
inline void pc(char ch) {
	if (ot==os+131072) {
		fwrite(buf,1,131072,stdout); ot=os;
	}
	(*ot++) = ch;
}
inline void lwrite(ll x) {
	int tot=0; if (!x) ss[++tot]='0';
	while (x) {
		ss[++tot]=int(x%10LL)|'0'; x/=10LL;
	}
	for (int i=tot; i; --i) pc(ss[i]);
	pc(' ');
}
int main() {
	freopen("make.in", "r", stdin);
	freopen("make.out", "w", stdout);
	int n=read(), m=read(), q=read();
	tr.push_back(INF,n+1); ll tot=0LL;
	for (int i=1; i<=m; ++i) {
		int l=read(), r=read();
		ll pos=tot-ll(l); tot+=ll(r-l+1);
		// f(l)=tot -> y = x+(tot-l)
		tmp = tr.split_value(l,r);
		for (chtholly_tree<ll>::node o : tmp) vec.push_back(make_pair(pos-o.val,o.r-o.l+1));
		tr.assign(l, r, pos);
	}
	sort(vec.begin(), vec.end());
	//for (pair<ll,int> p : vec) printf("%lld : %d\n",p.first,p.second);
	for (int i=1; i<=q; ++i) qry.push_back(make_pair(lread(),i));
	sort(qry.begin(), qry.end(), greater<pair<int,int> >());
	tot = 0LL;
	for (pair<ll,int> p : qry) {
		while ((!vec.empty())&&(vec.back().first>p.first)) {
			tot+=ll(vec.back().second); vec.pop_back();
		}
		res[p.second] = tot;
	}
	os=ot=buf;
	for (int i=1; i<=q; ++i) lwrite(res[i]);
	fwrite(buf, 1, ot-os, stdout);
	return 0;
}
