#include <bits/stdc++.h>

using ull = unsigned long long;

const int N = 280000;
const int Mod = 998244353;

typedef std::vector<int> Poly;

namespace Pol {
	int pow(int a, int b, int ans = 1);
	int add(int a, int b) {
		return (a += b) >= Mod ? a -= Mod : a;
	}
	int sub(int a, int b) {
		return (a -= b) < 0 ? a += Mod : a;
	}
	void inc(int &a, int b) {
		(a += b) >= Mod ? a -= Mod : a;
	}
	void dec(int &a, int b) {
		(a -= b) < 0 ? a += Mod : a;
	}
	void init_Poly(int n = N);
	void DIT(int *A, int lim);
	void DIF(int *A, int lim);
	Poly inv(Poly A, int n);
	Poly mult(const Poly &A, int n, const Poly &B, int m);
	Poly operator*(const Poly &A, const Poly &B) {
		return mult(A, A.size(), B, B.size());
	}
	Poly Tmul(const Poly &A, int n, const Poly &B, int m);
	Poly getv(Poly A, int n, const std::vector<int> &f, int m);
	Poly drv(const Poly &A, int n);
	Poly itg(const Poly &A, int n);
	Poly ln(const Poly &A, int n);
	Poly exp(Poly A, int n);
	int fac[N], ifac[N], iv[N];
	Poly G[N << 1];
	ull tmp[N];
	int gw[N];
}  // namespace Pol

int main() {
	Pol::init_Poly();
	int n, m;
	scanf("%d %d", &n, &m);
	Poly F(n);
	for (int i = 0; i < n; ++i) scanf("%d", &F[i]);
	Poly G = Pol::ln(Pol::inv(Pol::exp(F, n), n), n);
	for (int i = 0; i < n; ++i) printf("%d%c", G[i], " \n"[i == n - 1]);
	std::vector<int> f(m);
	for (int i = 0; i < m; ++i) scanf("%d", &f[i]);
	G = Pol::getv(F, n, f, m);
	for (int i = 0; i < m; ++i) printf("%d%c", G[i], " \n"[i == m - 1]);
	return 0;
}

namespace Pol {
	void DIT(int *A, int lim) {
		for (int i = 0; i < lim; ++i) tmp[i] = A[i];
		for (int l = 1; l < lim; l <<= 1) {
			ull *k = tmp;
			for (int *g = gw; k < tmp + lim; k += (l << 1), ++g) {
				for (ull *x = k; x < k + l; ++x) {
					int o = x[l] % Mod;
					x[l] = 1ll * (*x + Mod - o) **g % Mod, *x += o;
				}
			}
		}
		int iv = pow(lim, Mod - 2);
		for (int i = 0; i < lim; ++i) A[i] = 1ll * tmp[i] % Mod * iv % Mod;
		std::reverse(A + 1, A + lim);
	}
	void DIF(int *A, int lim) {
		for (int i = 0; i < lim; ++i) tmp[i] = A[i];
		for (int l = lim / 2; l >= 1; l >>= 1) {
			ull *k = tmp;
			for (int *g = gw; k < tmp + lim; k += (l << 1), ++g) {
				for (ull *x = k; x < k + l; ++x) {
					int o = 1ll * x[l] **g % Mod;
					x[l] = *x + Mod - o, *x += o;
				}
			}
		}
		for (int i = 0; i < lim; ++i) A[i] = tmp[i] % Mod;
	}
	Poly mult(const Poly &A, int n, const Poly &B, int m) {
		if (n + m < 255) {
			Poly ans(n + m - 1);
			std::fill(tmp, tmp + n + m, 0);
			for (int i = 0; i < n; ++i)
				for (int j = 0; j < m; ++j) tmp[i + j] += 1ll * A[i] * B[j] % Mod;
			for (int i = 0; i < n + m - 1; ++i) ans[i] = tmp[i] % Mod;
			return ans;
		}
		int lim = 1;
		while (lim < (n + m - 1)) lim <<= 1;
		static int tA[N], tB[N];
		std::copy_n(A.begin(), n, tA), std::fill(tA + n, tA + lim, 0);
		std::copy_n(B.begin(), m, tB), std::fill(tB + m, tB + lim, 0);
		DIF(tA, lim), DIF(tB, lim);
		for (int i = 0; i < lim; ++i) tA[i] = 1ll * tA[i] * tB[i] % Mod;
		DIT(tA, lim);
		Poly ans(n + m - 1);
		std::copy_n(tA, n + m - 1, ans.begin());
		return ans;
	}
	Poly Tmul(const Poly &A, int n, const Poly &B, int m) {
		if (n + m < 255) {
			Poly ans(m - n + 1);
			std::fill(tmp, tmp + m - n + 2, 0);
			for (int i = 0; i < m; ++i)
				for (int j = i; j < n; ++j) tmp[j - i] += 1ll * B[i] * A[j] % Mod;
			for (int i = 0; i < m - n + 1; ++i) ans[i] = tmp[i] % Mod;
		}
		int lim = 1;
		while (lim < m) lim <<= 1;
		static int tA[N], tB[N];
		std::reverse_copy(A.begin(), A.begin() + n, tA), std::fill(tA + n, tA + lim, 0);
		std::copy_n(B.begin(), m, tB), std::fill(tB + m, tB + lim, 0);
		DIF(tA, lim), DIF(tB, lim);
		for (int i = 0; i < lim; ++i) tA[i] = 1ll * tA[i] * tB[i] % Mod;
		DIT(tA, lim);
		Poly ans(m - n + 1);
		std::copy_n(tA + n - 1, m - n + 1, ans.begin());
		return ans;
	}
	Poly inv(Poly A, int n) {
		int lim = 1;
		while (lim < (n << 1)) lim <<= 1;
		Poly F(lim), G(lim);
		A.resize(lim);
		G[0] = pow(A[0], Mod - 2);
		int now = 1;
		static int tA[N], tB[N];
		while (now < n) {
			std::copy_n(A.begin(), now << 1, F.begin());
			int lim = now << 2;
			std::copy_n(G.begin(), lim, tA);
			std::copy_n(F.begin(), lim, tB);
			DIF(tA, lim), DIF(tB, lim);
			for (int i = 0; i < lim; ++i) tA[i] = 1ll * sub(2, 1ll * tA[i] * tB[i] % Mod) * tA[i] % Mod;
			DIT(tA, lim);
			std::copy_n(tA, now << 1, G.begin());
			now <<= 1;
		}
		G.resize(n);
		return G;
	}
	Poly drv(const Poly &A, int n) {
		Poly ans(n - 1);
		for (int i = 0; i < n - 1; ++i) ans[i] = 1ll * A[i + 1] * (i + 1) % Mod;
		return ans;
	}
	Poly itg(const Poly &A, int n) {
		Poly ans(n + 1);
		for (int i = 0; i < n; ++i) ans[i + 1] = 1ll * A[i] * iv[i + 1] % Mod;
		return ans;
	}
	Poly ln(const Poly &A, int n) {
		Poly F = drv(A, n), G = inv(A, n);
		F = mult(F, n - 1, G, n);
		F.resize(n - 1);
		F = itg(F, n - 1);
		return F;
	}
	Poly exp(Poly A, int n) {
		int lim = 1;
		while (lim < (n << 1)) lim <<= 1;
		A.resize(lim);
		Poly L(lim);
		int now = 1;
		static int tF[N], tG[N], tL[N];
		std::fill(tG, tG + lim, 0), std::fill(tF, tF + lim, 0);
		tG[0] = 1;
		while (now < n) {
			int lim = now << 2;
			std::copy_n(tG, now, L.begin());
			L = ln(L, std::min(now << 1, n));
			L.resize(lim);
			std::copy_n(A.begin(), now << 1, tF);
			std::copy_n(L.begin(), lim, tL);
			DIF(tF, lim), DIF(tG, lim), DIF(tL, lim);
			for (int i = 0; i < lim; ++i) tG[i] = 1ll * tG[i] * sub(add(1, tF[i]), tL[i]) % Mod;
			DIT(tG, lim);
			std::fill(tG + (now << 1), tG + lim, 0);
			now <<= 1;
		}
		Poly G(n);
		std::copy_n(tG, n, G.begin());
		return G;
	}
	void getg(int x, int xl, int xr, const Poly &f, int m) {
		if (xl == xr) {
			G[x].resize(2);
			G[x][0] = 1;
			if (xl >= m)
				G[x][1] = 0;
			else
				G[x][1] = Mod - f[xl];
			return;
		}
		int xm = (xl + xr) >> 1;
		getg(x << 1, xl, xm, f, m), getg(x << 1 | 1, xm + 1, xr, f, m);
		G[x] = mult(G[x << 1], xm - xl + 2, G[x << 1 | 1], xr - xm + 1);
	}
	void getans(int x, int xl, int xr, Poly &ans, int m, const Poly &h) {
		if (xl >= m) return;
		if (xl == xr) return void(ans[xl] = h[0]);
		int xm = (xl + xr) >> 1;
		Poly hl = Tmul(G[x << 1 | 1], xr - xm + 1, h, xr - xl + 1);
		getans(x << 1, xl, xm, ans, m, hl);
		Poly hr = Tmul(G[x << 1], xm - xl + 2, h, xr - xl + 1);
		getans(x << 1 | 1, xm + 1, xr, ans, m, hr);
	}
	Poly getv(Poly A, int n, const std::vector<int> &f, int m) {
		n = std::max(n, m);
		A.resize(n);
		getg(1, 0, n - 1, f, m);
		Poly now = inv(G[1], n);
		std::reverse(now.begin(), now.begin() + n);
		Poly h = mult(now, n, A, n);
		for (int i = 0; i < n; ++i) h[i] = h[i + n - 1];
		h.resize(n);
		Poly ans(m);
		getans(1, 0, n - 1, ans, m, h);
		return ans;
	}
	void init_Poly(int n) {
		int t = 1;
		while ((1 << t) < n) ++t;
		t = std::min(t - 1, 21);
		gw[0] = 1, gw[1 << t] = pow(31, 1 << (21 - t));
		for (int i = t; i; --i) gw[1 << (i - 1)] = 1ll * gw[1 << i] * gw[1 << i] % Mod;
		for (int i = 1; i < (1 << t); ++i) gw[i] = 1ll * gw[i & (i - 1)] * gw[i & -i] % Mod;
		--n;
		fac[0] = 1;
		for (int i = 1; i <= n; ++i) fac[i] = 1ll * fac[i - 1] * i % Mod;
		ifac[n] = Pol::pow(fac[n], Mod - 2);
		for (int i = n - 1; i >= 0; --i) ifac[i] = 1ll * ifac[i + 1] * (i + 1) % Mod;
		for (int i = 1; i <= n; ++i) iv[i] = 1ll * ifac[i] * fac[i - 1] % Mod;
	}
	int pow(int a, int b, int ans) {
		while (b) {
			if (b & 1) ans = 1ll * ans * a % Mod;
			a = 1ll * a * a % Mod;
			b >>= 1;
		}
		return ans;
	}
}  // namespace Pol
